﻿using Newtonsoft.Json;
using System.Text.RegularExpressions;
using static NLToCode.Evaluation.Utils;

namespace NLToCode.Evaluation {
    public class Benchmark {

        public int Id { get; set; }
        public string Question { get; set; }
        public string Answer { get; set; }
        public TableData Dataset { get; set; }
        public string Source { get; set; }
        public string InputTable { get; set; }
        public string MatchColumns { get; set; }
        public List<string> PredictedCode { get; set; }
        public Tuple<string, TableData> GroundTruthOutput { get; set; }
        public List<Tuple<string, TableData>> PredictedOutputs { get; set; }
        public bool ResultFoundTop1 { get; set; }
        public StepsMetadata MetaData { get; set; }

        public static Benchmark Parse(string path, string id) {
            Benchmark benchmark = null;
            try {
                var dirPath = $@"{path}\{id}";
                benchmark = JsonConvert.DeserializeObject<Benchmark>(File.ReadAllText($@"{path}\{id}").Replace("\"Annotation\":", "\"Question\":").Replace("\"Query\":", "\"Answer\":"));
                benchmark = ProcessBenchmark(benchmark);
                return benchmark;
            }
            catch (Exception e) {
                Logger.Error(e.Message);
                Logger.Error(e.StackTrace);
                return null;
            }
        }
        public static List<Benchmark> ParseJsonl(string path) {
            List<Benchmark> benchmarks = null;
            try {
                benchmarks = File.ReadAllLines($@"{path}").Select(t => JsonConvert.DeserializeObject<Benchmark>(t.Replace("\"Annotation\":", "\"Question\":").Replace("\"Query\":", "\"Answer\":"))).ToList();
                return benchmarks;
            }
            catch (Exception e) {
                Logger.Error(e.Message);
                Logger.Error(e.StackTrace);
                return null;
            }
        }

        public static Benchmark ProcessBenchmark(Benchmark ben) {
            ben.Source = Regex.Replace(ben.Source, @"[^\u0000-\u007F]+", "");
            ben.Question = Regex.Replace(ben.Question, @"[^\u0000-\u007F]+", "");
            ben.Answer = Regex.Replace(ben.Answer, @"[^\u0000-\u007F]+", "");
            ben.Dataset.Header = ben.Dataset.Header.Select(p => Regex.Replace(p, @"[^\u0000-\u007F]+", "")).ToList();
            ben.Dataset.Values = ben.Dataset.Values.Select(p => p.Select(q => Regex.Replace(q, @"[^\u0000-\u007F]+", "")).ToList()).ToList();
            ben.InputTable = Regex.Replace(ben.InputTable, @"[^\u0000-\u007F]+", "");
            return ben;
        }

        public static List<Benchmark> ParseMany(string path, string fileType) {
            if (fileType == "Json") {
                return new DirectoryInfo(path)
                .EnumerateFiles().Where(file => file.Name.EndsWith(".json"))
                .Select(file => Parse(path, file.Name))
                .Where(s => s != null)
                .ToList();
            }
            else {
                return ParseJsonl(path);
            }
        }

    }

    public class TableData {
        public List<string> Header { get; set; }
        public List<List<string>> Values { get; set; }
        public string ColumnTypes { get; set; }
    }

    public class StepsMetadata{
        public List<Step> Steps { get; set; }
        public string Filepath { get; set; }
    }
}
